package coreservlets.listeners;

import java.util.*;
import javax.servlet.*;

/** Proces nasuchujcy, ktry zlicza dania
 *  oraz czas nadejcia kadego z da. Na podstawie
 *  tych danych obliczana jest liczba da na sekund.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class RequestCounter implements ServletRequestListener {
  private ArrayList<Long> requestRecords = null;
  private static boolean countingFinished = false;

  public void requestInitialized(ServletRequestEvent requestEvent) {
    if (countingFinished) {
      return;
    }
    recordRequest(requestEvent, System.currentTimeMillis());
  }
  
  private void recordRequest(ServletRequestEvent requestEvent,
                             Long time) {
    // Odczytanie informacji o daniach i czasie ich zarejestrowania
    ArrayList<Long> records = getRequestRecords(requestEvent);
    records.add(time);
  }
  
  private ArrayList<Long> 
          getRequestRecords(ServletRequestEvent requestEvent) {
    // Sprawdzenie, czy obiekt jest ju w pamici podrcznej
    if (this.requestRecords != null) {
      return this.requestRecords;
    }
    
    // Zainicjowanie requestRecords i zapisanie go w ServletContext
    ServletContext context = requestEvent.getServletContext();
    requestRecords = new ArrayList<Long>();
    context.setAttribute("requestRecords", requestRecords);
    return requestRecords;
  }

  /** Umoliwienie klasom zewntrznym zatrzymania
   *  procesu zbierania statystyk.
   */
  public static void setCountingFinished(boolean countingFinished) {
    RequestCounter.countingFinished = countingFinished;
  }

  public void requestDestroyed(ServletRequestEvent requestEvent) {}
}